#-*- coding: 1250 -*-
from wordcloud import WordCloud
import pathlib

import imageio
import os 

MASK_DIRECTORY = './maski'
MASK_EXTENSION = '.png'
MASK_PREFIX = 'mask_'

RESULT_DIRECTORY = './wynik' 
RESULT_EXTENSION = '.png'


tekst = pathlib.Path('../RomeoAndJuliet.txt').read_text()

maskfiles = [x for x in os.listdir(MASK_DIRECTORY)]
masknames = []

for x in maskfiles:
    fname = os.path.basename(x)
    fname, fext = os.path.splitext(fname)
    if fext.lower() == MASK_EXTENSION:
        if fname.lower().startswith(MASK_PREFIX):
            maskkind = fname[len(MASK_PREFIX):]
            masknames.append((maskkind, x))
            
for maskkind in masknames:
    maskfile = maskkind[1]
    maskname = maskkind[0]  
    
    mask_image = imageio.imread(MASK_DIRECTORY + '/' + maskfile)

    wordcloud = WordCloud(colormap='prism', mask=mask_image,
                          background_color='white')
    
    wordcloud = wordcloud.generate(tekst)
           
    filename = pathlib.Path(f'{RESULT_DIRECTORY}/RomeoAndJuliet_{maskname}{RESULT_EXTENSION}');   
    print('Wygenerowano:', filename)
    wordcloud = wordcloud.to_file(filename)
