
from pygame import image, Surface
from maze_run.load_tiles import load_tiles, get_tile_rect
from maze_run.load_tiles import SIZE
from maze_run.generate_maze import create_maze
from maze_run.util import debug_print


def parse_grid(data):
    """Parsuje reprezentację tekstową do postaci zagnieżdżonej listy"""
    return [list(row) for row in data.strip().split("\n")]


def draw_grid(data, tile_img, tiles):
    """Zwraca obraz siatki złożonej z kafelków"""
    debug_print("poziom rysowania", data)
    xsize = len(data[0]) * SIZE
    ysize = len(data) * SIZE
    img = Surface((xsize, ysize))
    for y, row in enumerate(data):
        for x, char in enumerate(row):
            rect = get_tile_rect(x, y)
            img.blit(tile_img, rect, tiles[char])
    return img


if __name__ == '__main__':
    tile_img, tiles = load_tiles()
    level = create_maze(12, 7)
    level = parse_grid(level)
    maze = draw_grid(level, tile_img, tiles)
    image.save(maze, 'maze.png')
