
# Rozdział 15 - Dekompozycja zadań programistycznych

import pygame
from pygame.locals import USEREVENT, KEYDOWN


EXIT = USEREVENT
UPDATE_DISPLAY = USEREVENT + 1
MOVE_GHOST = USEREVENT + 2


def move_player(event):
    """porusza się w odpowiedzi na wciśnięcie klawisza"""
    print('player moves')

def move_ghost(event):
    """Duch porusza się losowo"""
    print('ruch ducha')

def update_graphics(event):
    """Ponowne narysowanie okna gry"""
    print('zaktualizowano grafikę')
    pass



callbacks = {
    KEYDOWN: move_player,
    MOVE_GHOST: move_ghost,
    UPDATE_DISPLAY: update_graphics,
}

def post_event(event):
    """Przykład zdarzenia wygenerowanego przez użytkownika"""
    exit = pygame.event.Event(EXIT)
    pygame.event.post(exit)

def event_loop(callbacks, delay=10):
    """Przetwarza zdarzenia i aktualizuje wywołania zwrotne."""
    running = True
    while running:
        pygame.event.pump()
        event = pygame.event.poll()
        action = callbacks.get(event.type)
        if action:
            action(event)
        pygame.time.delay(delay)
        if event.type == EXIT:
            running = False


if __name__ == '__main__':
    pygame.init()
    pygame.display.set_mode((10, 10))
    pygame.time.set_timer(UPDATE_DISPLAY, 1000)
    pygame.time.set_timer(MOVE_GHOST, 300)
    pygame.time.set_timer(EXIT, 5000)
    event_loop(callbacks)
