
import sqlite3

DB_SETUP = '''
CREATE TABLE IF NOT EXISTS scores (
    player VARCHAR(25),
    score INTEGER);
    '''

# utworzenie bazy danych
db = sqlite3.connect('highscores.sqlite')
db.executescript(DB_SETUP)

# wypełnienie bazy danych wpisami
insert = 'INSERT INTO scores VALUES (?,?);'
db.execute(insert, ('Ada', 5500))
db.execute(insert, ('Bogdan', 4400))
db.execute(insert, (3300, 'Czesław'))


# pobranie pięciu najlepszych wpisów w porządku malejącym
query = 'SELECT player, score FROM scores ORDER BY score DESC LIMIT 5;'
for result in db.execute(query):
    player, score = result
    print(result)
