@app.route("/entry/add", methods=["GET"])
@login_required # Wymuszone uwierzytelnienie
def add_entry_get():
    """Wyświetlenie formularza umożliwiającego dodanie nowego wpisu"""
    return render_template("add_entry.html")


@app.route("/entry/add", methods=["POST"])
@login_required # Wymuszone uwierzytelnienie
def add_entry_post():
    """Pobranie formularza wpisu i umieszczenie informacji w bazie danych"""
    entry = Entry(
        title=request.form["title"],
        content=request.form["content"],
        author=current_user
    )
    session.add(entry)
    session.commit()
    return redirect(url_for("entries"))

@app.route("/login", methods=["GET"])
def login_get():
    """Wyświetlenie strony logowania"""
    return render_template("login.html")

@app.route("/login", methods=["POST"])
def login_post():
    """Sprawdzenie, czy dane użytkownika znajdują się w bazie danych"""
    email = request.form["email"]
    password = request.form["password"]
    user = session.query(User).filter_by(email=email).first()
    if not user or not check_password_hash(user.password, password):
        flash("Nieprawidłowa nazwa użytkownika lub hasło", "danger")
        return redirect(url_for("login_get"))

    login_user(user)
    return redirect(request.args.get('next') or url_for("entries"))
