import functools
import time
from decorator import *

def _memoize(func, *args, **kw):
    if kw:  # Typ frozenset został użyty, aby zapewnić możliwość wygenerowania wartości hash
        key = args, frozenset(kw.items())
    else:
        key = args
    cache = func.cache  # Atrybut dodany przez memoize
    if key not in cache:
        cache[key] = func(*args, **kw)
    return cache[key]
