import numpy as np
import matplotlib.pyplot as plt
from matplotlib.animation import FuncAnimation
from multiprocessing import Queue, Process, Pipe
from time import time

def Laplasjan(T,dx):
  return (T[1:-1,2:]+T[1:-1,:-2]+T[2:,1:-1]+T[:-2,1:-1]-4*T[1:-1,1:-1])/dx**2

spf = 50   # krokow na klatke
v = 15
N=200
T=25*np.ones((N,N))
dx=1./N					# [m]
dt=dx**2/4				# stabilnosc metody!
T[0,:]=50				# [C]
T[-1,:]=0				# [C]
k = 5.8e-2 						# [W/K, stal 1mm]
Q=np.zeros((N,N))
for j in range(N//4,3*N//4):
  Q[int(N/2+N/10*np.sin(20.*(j-N/2)/N)),j]=20 / dx		# [W/m**2]

imax=60000

def proces(T,Q,pL,pP,pK):
  for i in range(imax//spf):
    for j in range(spf):
      pL.send(T[:,:1])
      pP.send(T[:,-1:])
      kL=pL.recv()
      kP=pP.recv()
      T[1:-1,:]+= v* (k*Laplasjan(np.hstack((kL,T,kP)),dx)+Q[1:-1,:])*dt
    pK.send(T)

def kolekcjoner(lista_koncow,q):
  for i in range(imax//spf):
    q.put(np.hstack([koniec.recv() for koniec in lista_koncow]))

n=3
q=Queue()
konce=sum([list(Pipe()) for _ in range(n)],[])
konce=[konce[-1]]+konce[:-1]
Kpi=[Pipe() for _ in range(n)]
procesy=[Process(target=proces,args=(
  T[:,1+i*(N-2)//n:1+(i+1)*(N-2)//n],
  Q[:,1+i*(N-2)//n:1+(i+1)*(N-2)//n],
  konce[2*i], konce[2*i+1], Kpi[i][0]
  )) for i in range(n)]
for i in procesy:
  i.start()
Process(target=kolekcjoner,args=([p[1] for p in Kpi],q)).start()

fig = plt.figure(figsize=(12,9))
w=plt.imshow(T,vmin=0,vmax=78,cmap='jet')

def anim(i):
  t=time()
  w.set_array(q.get())
  print(i,time()-t)

a=FuncAnimation(fig,anim,interval=20,frames=imax//spf-1,repeat=False)
plt.show()
