"""
makedata.py

Program do tworzenia testowych zbiorów danych wolumetrycznych.

Autor: Mahesh Venkitachalam
"""

import sys, os
import numpy as np
import Image

def makeSphereCuboid():
    """Tworze wolumenu z kulą i prostopadłościanem"""
    Nx, Ny, Nz = 256, 256, 256
    Nx2, Ny2, Nz2 = int(Nx/2), int(Ny/2), int(Nz/2)
    # wypełnienie zerami
    a = np.zeros(Nx*Ny*Nz, np.uint8).reshape(Nx, Ny, Nz)
    # ustawienie danych
    for k in range(Nz):
        for j in range(Ny):
            for i in range(Nx):
                # wewnątrz prostopadłościanu?
                if abs(i-Nx2) < 40 and abs(j-Ny2) < 30 and abs(k-Nz2) < 20:
                    a[i][j][k] = min(2*(-Nx2 + 40 + i), 255)
                else:
                    # wewnątrz kuli?
                    if ((i-Nx2)*(i-Nx2) + (j-Ny2)*(j-Ny2) + 
                        (k-Nz2)*(k-Nz2)) < 100*100:
                        a[i][j][k] = 50
    # tworzenie katalogu, jeśli nie istnieje                
    imgDir = 'sphere-cuboid'
    if not os.path.exists(imgDir):
        os.makedirs(imgDir)
    # zapisywanie obrazów
    for i in range(Nz):
        # tworzenie obrazu
        im = Image.fromarray(a[i])
        # zapisywanie pliku
        fileName = os.path.join(imgDir, 'sphere-cuboid%03d.png' % i)
        im.save(fileName)

# funkcja main()
def main():
  # użycie sys.argv w razie potrzeby
  print('uruchamianie makedata...')
  makeSphereCuboid()

# wywołanie main
if __name__ == '__main__':
  main()
