# -*- coding: utf-8 -*-
from xml.dom import minidom

# Przetworzenie pliku XML na drzewo DOM
xmldoc = minidom.parse('emails.xml')

# Otrzymanie węzłów w korzeniu drzewa
cNodes = xmldoc.childNodes

# Bezpośredni dostęp do węzłów
print "Węzeł DTD\n================="
print cNodes[0].toxml("utf-8")

# Odnalezienie węzła po nazwie
print "\nAdresy odbiorcy ('To')\n==================="
nList = cNodes[1].getElementsByTagName("to")
for node in nList:
   eList = node.getElementsByTagName("addr")
   for e in eList:
      print e.toxml("utf-8")

print "\nAdresy nadawcy ('From')\n==================="
nList = cNodes[1].getElementsByTagName("from")
for node in nList:
   eList = node.getElementsByTagName("addr")
   for e in eList:
      print e.toxml("utf-8")

# Przejście drzewa węzłów
def printNodes (nList, level):
   for node in nList:
      if node.nodeValue != None:   
          print ("  ")*level, node.nodeName.encode('utf-8'), node.nodeValue.encode('utf-8')
      else:
          print ("  ")*level, node.nodeName.encode('utf-8')
      printNodes(node.childNodes, level+1)

print "\nWęzły\n==================="
printNodes(xmldoc.childNodes, 0)
