class CardHolder:
    acctlen = 8                                # Dane klasy
    retireage = 62.5

    def __init__(self, acct, name, age, addr):
        self.acct = acct                       # Dane instancji
        self.name = name                       # Te także wywołują metody ustawiające właściwości
        self.age  = age                        # Zmiana nazwy __X w celu uzyskania nazwy klasy
        self.addr = addr                       # Atrybut addr nie jest zarządzany
                                               # Atrybut remain nie ma danych
    def getName(self):
        return self.__name
    def setName(self, value):
        value = value.lower().replace(' ', '_')
        self.__name = value
    name = property(getName, setName)          # Lub dekoratory @ dla obu

    def getAge(self):
        return self.__age
    def setAge(self, value):
        if value < 0 or value > 150:
            raise ValueError('niepoprawny wiek')
        else:
            self.__age = value
    age = property(getAge, setAge)

    def getAcct(self):
        return self.__acct[:-3] + '***'
    def setAcct(self, value):
        value = value.replace('-', '')
        if len(value) != self.acctlen:
            raise TypeError('niepoprawny numer konta')
        else:
            self.__acct = value
    acct = property(getAcct, setAcct)

    def remainGet(self):                       # Mógłby być metodą, nie atrybutem
        return self.retireage - self.age       # O ile niewykorzystywany jeszcze jako atrybut
    remain = property(remainGet)

