class CardHolder:                                # Użycie dzielonego stanu deskryptora
    acctlen = 8                                  # Dane klasy
    retireage = 62.5

    def __init__(self, acct, name, age, addr):
        self.acct = acct                         # Dane instancji
        self.name = name                         #  także wywołują metodę __set__
        self.age  = age                          # Zmiana nazwy __X nie jest konieczna: w deskryptorze
        self.addr = addr                         # Atrybut addr nie jest zarządzany
                                                 # Atrybut remain nie ma danych
    class Name:
        def __get__(self, instance, owner):      # Zmienne klasy: lokalne dla CardHolder
            return self.name
        def __set__(self, instance, value):
            value = value.lower().replace(' ', '_')
            self.name = value
    name = Name()

    class Age:
        def __get__(self, instance, owner):
            return self.age                             # Użycie danych deskryptora
        def __set__(self, instance, value):
            if value < 0 or value > 150:
                raise ValueError('niepoprawny wiek')
            else:
                self.age = value
    age = Age()

    class Acct:
        def __get__(self, instance, owner):
            return self.acct[:-3] + '***'
        def __set__(self, instance, value):
            value = value.replace('-', '')
            if len(value) != instance.acctlen:          # Użycie danych instancji klasy
                raise TypeError('niepoprawny numer konta')
            else:
                self.acct = value
    acct = Acct()

    class Remain:
        def __get__(self, instance, owner):
            return instance.retireage - instance.age    # Wywołuje Age.__get__
        def __set__(self, instance, value):
            raise TypeError('nie można ustawić remain') # Inaczej zezwolilibyśmy na ustawienie
    remain = Remain()

