"""
Dekorator mierzący czas wykonania zarówno funkcji, jak i metody.
"""
import time

def timer(label='', trace=True):               # Dla argumentów dekoratora: zachowanie argumentów
    def onDecorator(func):                     # Dla dekoracji @: zachowanie udekorowanej funkcji
        def onCall(*args, **kargs):            # W momencie wywołania: wywołanie oryginału
            start   = time.perf_counter()      # Stan to zakresy – atrybuty funkcji
            result  = func(*args, **kargs)
            elapsed = time.perf_counter() - start
            onCall.alltime += elapsed
            if trace:
                if label: print(label, end=' ')
                print(f'{func.__name__}: {elapsed:.5f}, {onCall.alltime:.5f}')
            return result
        onCall.alltime = 0
        return onCall
    return onDecorator

