"Test względnej szybkości różnych sposobów iteracji"

from timer_runner import runner
repslist = list(range(10_000))

def forLoop():
    res = []
    for x in repslist:
        res.append(abs(x))
    return res

def listComp():
    return [abs(x) for x in repslist]

def mapCall():
    return list(map(abs, repslist))              # Użycie list() w celu wyświetlenia wyników

def genExpr():
    return list(abs(x) for x in repslist)        # Użycie list() w celu wyświetlenia wyników

def genFunc():
    def gen():
        for x in repslist:
            yield abs(x)
    return list(gen())                           # Użycie list() w celu wyświetlenia wyników 

runner(forLoop, listComp, mapCall, genExpr, genFunc)
