# -*- coding: Latin-1 -*-

#----------------------------------------------------------------------------
# Demonstruje wszystkie sposoby kodowania tekstu spoza ASCII w Pythonie oraz kodowania zrdlowe.

# Jesli ten plik jest zapisany jako tekst Latin-1, dziala tak jak jest. Ale zmiana
# linii kodowania powyzej na ASCII lub UTF-8 spowoduje blad, poniewaz
# zapisane w wartosci myStr1 znaki Latin-1 0xc4 i 0xe8 nie sa prawidlowe w zadnym z tych kodowan.

# Linia UTF-8 dziala, jesli ten plik jest  zapisany jako UTF-8, aby tekst myStr1
# pasowal. Poniewaz UTF-8 jest domyslnym kodowaniem dla zrdla, linia powyzej jest
# opcjonalna, jesli plik jest zapisany jako UTF-8 lub jego tekst jest calkowicie zgodny z UTF-8
# (np. ASCII, ktre jest podzbiorem zarwno kodowania Latin-1, jak i UTF-8).#----------------------------------------------------------------------------

myStr1 = 'ABC'                                      # Surowe, zgodne z kodowaniem zrdla

myStr2 = 'A\xc4B\xe8C'                                # Szesnastkowe ucieczki punktw kodowych

myStr3 = 'A\u00c4B\U000000e8C'                        # Krtkie/dlugie ucieczki Unicode

myStr4 = 'A' + chr(0xC4) + 'B' + chr(0xE8) + 'C'      # Zlaczone punkty kodowe
import sys, locale
print('Kodowanie systemowe: ', sys.platform)
print('Domyslne kodowanie metody encode: ', sys.getdefaultencoding())
print('Domyslne kodowanie funkjci open:', locale.getpreferredencoding(False))

for aStr in (myStr1, myStr2, myStr3, myStr4):
    print(f'{aStr}, strlen={len(aStr)}', end=', ')    # Zdekodowany tekst + dlugosc

    bytes1 = aStr.encode()               # Zgodnie z domyslnym UTF-8: 2 bajty dla akcentw
    bytes2 = aStr.encode('latin-1')      # Jawne kodowanie Latin-1, 1 bajt na znak
   #bytes3 = aStr.encode('ascii')        # ASCII nie dziala: poza zakresem od 0 do 127

    print(f'byteslen1={len(bytes1)}, byteslen2={len(bytes2)}')   # Zakodowana dlugosc
