class ListInstance:
    """
    Klasa mieszana formatująca informacje wyświetlane przez metody
    print() i str() za pomocą zkodowanej tutaj dziedziczonej metody __str__.
    Wyświetla tylko atrybuty instancji. Self jest instancją klasy najniższej. Nazwy __X zapobiegają konfliktom z atrybutami klas.
    Działa dla klas ze slotami — __dict__ jest tutaj zapewnione przez brak slotów. 

    """
    def __attrnames(self):
        result = '\n'
        for attr in sorted(self.__dict__):                      # Sloty są w porządku
            result += f'\t{attr}={self.__dict__[attr]!r}\n'     # Reprezentacja dla cudzysłowów
        return result

    def __str__(self):
        return (f'<Instance of {self.__class__.__name__}, '     # Nazwa mojej klasy
                f'address {id(self):#x}:'                       # Mój adres (hex)
                f'{self.__attrnames()}>')                       # Lista nazwa=wartość

if __name__ == '__main__':
    import testmixin
    testmixin.tester(ListInstance)      # Test klasy w tym module

