class ListInstance:
    """
Klasa mieszana, która zapewnia formatowane print() lub str() dla instancji poprzez dziedziczenie str zakodowanego tutaj. Wyświetla tylko atrybuty instancji; self jest instancją najniższej klasy; nazewnictwo __X unika konfliktu z atrybutami klienta. Działa dla klas z slotami: dict jest zapewniany przez brak slotów tutaj.
    """
    def __attrnames(self):
        result = '\n'
        for attr in sorted(self.__dict__):                      # Sloty działają
            result += f'\t{attr}={self.__dict__[attr]!r}\n'     # Repr dla cudzysłowie
        return result

    def __str__(self):
        return (f'<Instance of {self.__class__.__name__}'       # Nazwa własnej klasy
                f'({self.__supers()}), '                        # Własne klasy nadrzędne
                f'address {id(self):#x}:'                       # asny adres (hex)
                f'{self.__attrnames()}>')                       # Lista nazwa=wartość

    def __supers(self):
        names = []
        for super in self.__class__.__bases__:            # Jeden poziom w górę od klasy
            names.append(super.__name__)                  # name, nie str(super)
        return ', '.join(names)

        # Lub: ', '.join(super.__name__ for super in self.__class__.__bases__)

if __name__ == '__main__':
    import testmixin                    # Założenie, że plik testmixin.py został skopiowany do  "."
    testmixin.tester(ListInstance)      # Test klasy w tym module

