"""
Wygeneruj prosty certyfikat ukończenia kursu: wyświetlany w konsoli 
i zapisany w automatycznie otwierających się plikach tekstowych i HTML. 

Uruchom z konsoli i wyświetl zapisane pliki wyjściowe, jeśli chcesz. 
Działa na wszystkich komputerach PC, ale może wymagać ręcznego otwarcia na smartfonach.
"""
import time, sys, html, os, locale

maxline = 60                               # Separatory wierszy
browser = True                             # Wyświetlić w przeglądarce?
saveto  = 'Certyfikat'                    # Przedrostek nazw plików wyjściowych

# Ustawienia lokalne daty i godziny (Polska)
locale.setlocale(locale.LC_TIME, "pl_PL.UTF-8")
current_time = time.localtime()

# Wartości szablonu
SEPT = '*' * maxline
DATE = time.strftime('%A, %b %d, %Y, %I:%M %p', current_time)
NAME = input('Wpisz swoje imię: ').strip() or 'Anonimowy czytelnik'
BOOK = 'Python. Wprowadzenie. Wydanie 6'
SITE = 'https://helion.pl/'       # Na potrzeby ikony, obrazu i linku



# Szablony f-string działają dla wstępnie ustawionych odwołań w kodzie
texttext = f"""
{SEPT}

⭐️ Oficjalny certyfikat ⭐️

Data: {DATE}

Niniejszy certyfikat potwierdza, iż:

\t{NAME}

przeczytał(a) opasły tom:

\t{BOOK}

I ma teraz prawo do wszystkich związanych z tym przywilejów, 
w tym kontynuowania nauki, jak tworzyć strony internetowe, 
graficzne interfejsy użytkownika na komputery, modele naukowe, aplikacje na smartfony i wszystko inne, 
co może wpłynąć na przyszłość informatyki. 

--Twój instruktor 🐍

(Uwaga: certyfikat jest nieważny, jeśli został pominięty choćby jeden rozdział.)

{SEPT}
"""

# Interakcja, konfiguracja
for c in 'Gratulacje!'.upper() + '👏' * 3:
    print(c, end=' ')
    sys.stdout.flush()    # Jeśli niektóre powłoki czekają na \n
    time.sleep(0.25)      # Odkrywaj wiadomość powoli, by było więcej zabawy
print(); time.sleep(3)

# Utworzenie wersji w postaci pliku tekstowego
textto = saveto + '.txt'
fileto = open(textto, 'w', encoding='utf8')
print(texttext, file=fileto)
fileto.close()

# Uruchom HTML: zastąpienie znaczników tekstowych znacznikami html
htmltext = texttext.replace(SEPT,   '<div class=cert>', 1)
htmltext = htmltext.replace(SEPT,   '</div>')
htmltext = htmltext.replace('⭐️ ', '<h1 align=center>⭐️&nbsp;', 1)
htmltext = htmltext.replace(' ⭐️', '&nbsp;⭐️</h1>')

# Modyfikacje wiersz po wierszu
linemods = []
for line in htmltext.split('\n'):
    if line == '':
        line = '<p>'
    elif line[:1] == '\t':
        line = f"<i>{'&nbsp;' * 4}{html.escape(line[1:])}</i>"   # 3.6+
    linemods.append(line)
htmltext = '\n'.join(linemods)
     
# Pomijane bity HTML (uważaj na ucieczki {{ and }})
preamble = f'''<!doctype html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link rel="icon" type="image/x-icon" href="{SITE}/favicon.ico">
<style> 
body  {{font-family: Arial, Helvetica, sans-serif;}} 
.cert {{background-color: cornsilk; padding: 16px; border: medium solid black;}}
</style>
<title>PW6W Certyfikat ukończenia</title>
</head>
'''

image, page = '_images/Helion_logo.jpg', 'https://helion.pl/'
footer = f'''
<table><tr>
<td><a href="{SITE}"><img src="{image}" hspace=10 height=50></a>
<td><a href="{SITE}" align=center><i>Wydawnictwo Helion</i></a>
</tr></table>
'''

# Złożenie wszystkiego w całość
htmltext = f'{preamble}<body bgcolor="#eee">{htmltext}{footer}</body></html>'

# Utworzenie wersji w postaci pliku html
htmlto = saveto + '.html'
fileto = open(htmlto, 'w', encoding='utf8')
print(htmltext, file=fileto)
fileto.close()

# Wyświetlenie rezultatów w konsoli
print(f'[File: {textto}]', end='')
print('\n' * 2, open(textto, encoding='utf8').read())

# Otworzenie dokumentów (może zakończyć się niepowodzeniem)
if browser:
    try:
        import webbrowser
        for doc in (textto, htmlto):
            webbrowser.open('file://' + os.path.abspath(doc))
    except Exception:
        print('Nie udało się otworzyć plików automatycznie - otwórz ręcznie.')

input('[Naciśnij Enter, aby zamknąć]')    # Nie zamykaj okna, dopóki użytkownik nie naciśnie Enter

