"""
Test dekoratora mierzącego czas wywołania na funkcjach i metodach. 
Dodano opóźnienia, aby wydłużyć niektóre zbyt szybkie wywołania.
"""

import sys, time
from timerdeco import timer


print('Funkcje-------------------------------------------------')
# Test on functions

@timer(trace=True, label='[CCC]==>')
def listcomp(N):                               # Jak  listcomp = timer(...)(listcomp)
    return [x * 2 for x in range(N)]           # listcomp(...) wywołuje onCall

@timer('[MMM]==>')
def mapcall(N):
    return list(map((lambda x: x * 2), range(N))) 

for func in (listcomp, mapcall):
    result = func(5)                           # Czas dla tego wywołania, wszystkich wywołań, zwracana wartość
    func(5_000_000)
    print(result)
    print(f'allTime = {func.alltime:.5f}\n')   # Całkowity czas wszystkich wywołań


print('Metody---------------------------------------------------')
# Test on methods

class Person:
    def __init__(self, name, pay):
        self.name = name
        self.pay  = pay

    @timer(label='$$')
    def giveRaise(self, percent):            # giveRaise = timer()(giveRaise)
        self.pay *= (1.0 + percent)          # tracer pamięta giveRaise
        time.sleep(0.25)

    @timer(label='@@')
    def lastName(self):                      # lastName = timer(...)(lastName)
        time.sleep(0.25)
        return self.name.split()[-1]         # Całkowity czas per klasa, nie instancja

sue = Person('Sue Jones', 100_000)
bob = Person('Bob Smith', 50_000)
sue.giveRaise(.20)                           # Wykonuje onCall(sue, .10)
bob.giveRaise(.10)

print(f'{int(sue.pay)=}, {int(bob.pay)=}')
print(f'{sue.lastName()=}, {bob.lastName()=}')    # Wykonuje onCall(sue), pamięta lastName

print(f'{Person.giveRaise.alltime=:.5f}, {Person.lastName.alltime=:.5f}')

