"""
Rejestruje i przetwarza informacje o pracownikach.
Uruchom ten plik bezpośrednio, aby przetestować jego klasy.
"""
from classtools import AttrDisplay                    # Użycie uniwersalnego narzędzia do wyświetlania

class Person(AttrDisplay):                            # Na tym poziomie dołączamy metodę __repr__
    """
    Tworzy i przetwarza rekordy osób
    """
    def __init__(self, name, job=None, pay=0):
        self.name = name
        self.job  = job
        self.pay  = pay

    def lastName(self):                               # Zakładamy, że nazwisko jest na końcu
        return self.name.split()[-1]

    def giveRaise(self, percent):                     # Procent musi się mieścić między 0 a 1
        self.pay = int(self.pay * (1 + percent))

class Manager(Person):
    """
    Dostosowana do własnych potrzeb klasa Person ze specjalnymi wymaganiami
    """
    def __init__(self, name, pay):
        Person.__init__(self, name, 'manager', pay)       # Nazwa zawodu jest domyślna

    def giveRaise(self, percent, bonus=.10):
        Person.giveRaise(self, percent + bonus)

if __name__ == '__main__':
    bob = Person('Robert Zielony')
    anna = Person('Anna Czerwona', job='programista', pay=100000)
    print(bob)
    print(anna)
    print(bob.lastName(), anna.lastName())
    anna.giveRaise(.10)
    print(anna)
    tom = Manager('Tomasz Czarny', 50000)
    tom.giveRaise(.10)
    print(tom.lastName())
    print(tom)

