# Zwykła klasa też może pełnić rolę metaklasy

class MetaObj:
    def __call__(self, classname, supers, classdict):
        print('W MetaObj.call:', classname, supers, classdict, sep='\n...')
        Class = self.__New__(classname, supers, classdict)
        self.__Init__(Class, classname, supers, classdict)
        return Class

    def __New__(self, classname, supers, classdict):
        print('W MetaObj.new: ', classname, supers, classdict, sep='\n...')
        return type(classname, supers, classdict)

    def __Init__(self, Class, classname, supers, classdict):
        print('W MetaObj.init:', classname, supers, classdict, sep='\n...')
        print('...inicjalizacja obiektu klasy:', list(Class.__dict__.keys()))

class Super:
    pass

print('Tworzenie klasy')
class Hack(Super, metaclass=MetaObj()):         # MetaObj jest tu instancją zwykłej klasy
    data = 1                                    # Operacja wykonywana na końcu instrukcji
    def meth(self, arg):
        return self.data + arg

print('Tworzenie instancji')
X = Hack()
print('Attrybuty:', X.data, X.meth(2))

