# Not listed in the book: nest the decorator's class

class Person:
    def __init__(self, name):
        self._name = name

    class Name:
        'Dokumentacja deskryptora name'

        def __get__(self, instance, owner):
            print('pobieranie...')
            return instance._name

        def __set__(self, instance, value):
            print('modyfikacja...')
            instance._name = value

        def __delete__(self, instance):
            print('usunięcie...')
            del instance._name

    name = Name()                      # Przypisanie deskryptora do atrybutu

bob = Person('Robert Zielony')        # bob ma zarządzany atrybut
print(bob.name)                       # Wykonuje Name.__get__
bob.name = 'Robert A. Zielony'        # Wykonuje Name.__set__
print(bob.name)
del bob.name                          # Wykonuje Name.__delete__

print('-'*20)
anna = Person('Anna Czerwona')        # anna także dziedziczy deskryptor
print(anna.name)
print(Name.__doc__)                   # Lub help(Name)
