class Adder:
    def __init__(self, start=[]):
        self.data = start
    def __add__(self, other):              # Przekazanie pojedynczego argumentu
        return self.add(other)             # Lewa strona jest w self
    def add(self, y):
        print('Nie zaimplementowano!')

class ListAdder(Adder):
    def add(self, y):
        return self.data + y

class DictAdder(Adder):
    def add(self, y):
        d = self.data.copy()               # Zmodyfikuj, by użyć self.data zamiast x
        d.update(y)                        # Lub "oszukać" poprzez użycie szybszych funkcji wbudowanych
        return d

x = ListAdder([1, 2, 3])
y = x + [4, 5, 6]
print(y)                                   # Wyświetla [1, 2, 3, 4, 5, 6]

z = DictAdder(dict(name='x')) + {'a': 1}
print(z)                                   # # Wyświetla {'name': 'Robert', 'a': 1}

