class CardHolder:                                # Użycie stanu dla klienta-instancji
    acctlen = 8                                  # Dane klasy
    retireage = 62.5

    def __init__(self, acct, name, age, addr):
        self.acct = acct                         # Dane instancji klienckiej
        self.name = name                         # Te także wywołują metodę __set__
        self.age  = age                          # Zmiana nazwy __X nie jest konieczna: w deskryptorze
        self.addr = addr                         # Atrybut addr nie jest zarządzany
                                                 # Atrybut remain nie ma danych
    class Name:
        def __get__(self, instance, owner):      # Zmienne klasy: lokalne dla CardHolder
            return instance.__name
        def __set__(self, instance, value):
            value = value.lower().replace(' ', '_')
            instance.__name = value
    name = Name()                                       # class.name i zmieniony atrybut

    class Age:
        def __get__(self, instance, owner):
            return instance.__age                       # Użycie danych *instancji*
        def __set__(self, instance, value):
            if value < 0 or value > 150:
                raise ValueError('niepoprawny wiek')
            else:
                instance.__age = value
    age = Age()                                         # class.age i zmieniony atrybut

    class Acct:
        def __get__(self, instance, owner):
            return instance.__acct[:-3] + '***'
        def __set__(self, instance, value):
            value = value.replace('-', '')
            if len(value) != instance.acctlen:          # Użycie danych instancji klasy
                raise TypeError('niepoprawny numer konta')
            else:
                instance.__acct = value
    acct = Acct()                                       # class.acct i zmieniona nazwa

    class Remain:
        def __get__(self, instance, owner):
            return instance.retireage - instance.age    # Wywołuje Age.__get__
        def __set__(self, instance, value):
            raise TypeError('nie można ustawić remain')        # Inaczej zezwolilibyśmy na ustawienie
    remain = Remain()

