"""
Test dekoratora rangetest (użycie różni się od rangetest0).
Wiersze z komentarzami zgłaszają błąd TypeError, o ile nie ustawiono "python –O" w wierszu poleceń powłoki.
"""
from rangetest import rangetest
def announce(what): print(what.center(24, '-'))   # Metoda str

# Testowanie funkcji, pozycyjne i po słowach kluczowych
announce('Funkcje')

@rangetest(age=(0, 120))                  # persinfo = rangetest(...)(persinfo)
def persinfo(name, age):
    print(f'{name} ma {age} lat')

@rangetest(M=(1, 12), D=(1, 31), Y=(0, 2024))
def birthday(M, D, Y):
    print(f'urodziny = {M}/{D}/{Y}')

persinfo('Robert', 40)
persinfo(age=40, name='Robert')
birthday(1, M=5, Y=2025)
#persinfo('Robert', 150)
#persinfo(age=150, name='Robert')
#birthday(40, M=5, Y=2025)

# Testowanie metod, pozycyjne i po słowach kluczowych
announce('Metody')

class Person:
    def __init__(self, name, job, pay):
        self.job  = job
        self.pay  = pay
                                          # giveRaise = rangetest(...)(giveRaise)
    @rangetest(percent=(0.0, 1.0))        # Wartość percent przekazana po nazwie lub pozycji
    def giveRaise(self, percent):
        self.pay = int(self.pay * (1 + percent))

bob = Person('Robert Zielony', 'programista', 100000)
anna = Person('Anna Czerwona', 'programista', 100000)
bob.giveRaise(.10)
anna.giveRaise(percent=.20)
print(bob.pay, anna.pay)
#bob.giveRaise(1.10)
#bob.giveRaise(percent=1.20)


# Testowanie pominiętych wartości domyślnych: pominięte
announce('Domyślne')

@rangetest(a=(1, 10), b=(1, 10), c=(1, 10), d=(1, 10))
def omitargs(a, b=7, c=8, d=9):
    print(a, b, c, d)

omitargs(1, 2, 3, 4)           # Pozycyjne
omitargs(1, 2, 3)              # Domyślne d
omitargs(1, 2, 3, d=4)         # Argument ze słowem kluczowym - d
omitargs(1, d=4)               # Domyślne b and c
omitargs(d=4, a=1)             # Jak wyżej
omitargs(1, b=2, d=4)          # Domyślne c
omitargs(d=8, c=7, a=1)        # Domyślne b

#omitargs(1, 2, 3, 11)         # Bad d
#omitargs(1, 2, 11)            # Bad c
#omitargs(1, 2, 3, d=11)       # Bad d
#omitargs(11, d=4)             # Bad a
#omitargs(d=4, a=11)           # Bad a
#omitargs(1, b=11, d=4)        # Bad b
#omitargs(d=8, c=7, a=11)      # Bad a

