"""
Plik: formats.py 
Różne wyspecjalizowane narzędzia do formatowania wyświetlania ciągów znaków. Przetestuj mnie za pomocą wbudowanego testu lub argumentów wiersza poleceń.

Do zrobienia: dodaj nawiasy dla ujemnych kwot pieniężnych, dodaj więcej funkcji.

Ten przykład został usunięty z książki z powodu ograniczeń miejsca i jest tu zamieszczony jedynie jako dodatkowy przykład do samodzielnej nauki. Część jego celu to pokazanie, że możesz tworzyć własne narzędzia zamiast polegać na wbudowanych funkcjach, takich jak "," w metodach formatujących (a dziś także f-stringi). Ogólnie lepiej jest nauczyć się łowić ryby, niż dostawać jedną, chociaż f'{9999999999:,}' i f'${-99999999.123:17,.2f}' mogą być łatwiejsze w tym konkretnym przypadku (choć mniej zabawne).
"""

def commas(N):
    """
    Formatuj liczbę całkowitą (lub podobną) N do wyświetlania z przecinkami pomiędzy grupami cyfr: "xxx,yyy,zzz".
    """
    digits = str(N)
    assert digits.isdigit()
    result = ''
    while digits:
        digits, last3 = digits[:-3], digits[-3:]
        result = (last3 + ',' + result) if result else last3
    return result

def money(N, numwidth=0, currency='$'):
    """
    Formatuj liczbę N do wyświetlania z przecinkami, z dwoma miejscami dziesiętnymi, poprzedzoną symbolem $ i znakiem, oraz opcjonalnym 
    wypełnieniem: "$ -xxx,yyy.zz". Ustaw numwidth=0, aby nie było wypełnienia spacjami, currency='', aby pominąć symbol, oraz użyj Unicode
    dla innych symboli (np. funt='\xA3', '\u00A3', lub '£').
    """
    sign   = '-' if N < 0 else ''
    N      = abs(N)
    whole  = commas(int(N))
    fract  = ('%.2f' % N)[-2:]
    number = '%s%s.%s' % (sign, whole, fract)
    return '%s%*s' % (currency, numwidth, number)

if __name__ == '__main__':
    def selftest():
        tests  = 0, 1        # kończy się niepowodzeniem: −1, 1.23
        tests += 12, 123, 1234, 12345, 123456, 1234567
        tests += 2 ** 32, 2 ** 100
        for test in tests:
            print(commas(test))

        print('')
        tests  = 0, 1, -1, 1.23, 1., 1.2, 3.14159
        tests += 12.34, 12.344, 12.345, 12.346
        tests += 2 ** 32, (2 ** 32 + .2345)
        tests += 1.2345, 1.2, 0.2345
        tests += -1.2345, -1.2, -0.2345
        tests += -(2 ** 32), -(2**32 + .2345)
        tests += (2 ** 100), -(2 ** 100)
        for test in tests:
            print('%s [%s]' % (money(test, 17), test))

    import sys
    if len(sys.argv) == 1:
        selftest()
    else:
        print(money(float(sys.argv[1]), int(sys.argv[2])))

