# Skrypt bazy danych do wypełniania i zapytań do bazy danych SQLite, przechowywany w pliku people.db

import sqlite3, time
conn = sqlite3.connect('people.db')    # Nazwa pliku bazy danych
curs = conn.cursor()                   # Przekazanie SQL za pomocą kursora

# Utwórz+wypełnij tabelę, jeśli jeszcze nie istnieje
tbl = curs.execute('wybierz nazwę z sqlite_master, gdzie nazwa = \'people\'')
if tbl.fetchone() is None:
    print('Tworzenie nowej tabeli')
    curs.execute('tworzenie tabeli z osobami (name, job, pay)')

    recs = [('Patrycja', 'menedżer', 40000), ('Anna', 'programista', 60000), ('Robert', 'programista', 50000)]
    for rec in recs:
        curs.execute('wstawienie wartości (?, ?, ?)', rec)
    conn.commit()

# Pokaż wszystkie wiersze
print('Wiersze:')
curs.execute('select * from people')
for row in curs.fetchall():
    print(row)

# Pokaż tylko programistów
print('Programiści:')
curs.execute("select name, pay from people where job = 'programista'")
colnames = [desc[0] for desc in curs.description]
while row := curs.fetchone():
    print('-' * 30)
    for (name, value) in zip(colnames, row):
        print(f'{name:<4} => {value}')

# Aktualizacja wynagrodzenia: widoczne podczas następnego uruchomienia
secs = int(time.time())  # UTC!
curs.execute('aktualizacja wynagrodzenia = ? gdzie stanowisko = ?', [secs, 'programista'])
conn.commit()

