"""
Kod testu umieszczony w osobnym pliku, aby można było wielokrotnie
korzystać z dekoratora
"""

import sys
from access import Private, Public

print('---------------------------------------------------------')
# Test 1: nazwy są publiczne, jeśli nie prywatne

@Private('age')                             # Person = Private('age')(Person)
class Person:                               # Person = onInstance ze stanem
    def __init__(self, name, age):
        self.name = name
        self.age  = age                     # Dostęp z wewnątrz działa normalnie
    def __add__(self, N):
        self.age += N                       # Operatory wbudowane przechwytywane przez klasy mieszane    def __str__(self):
        return f'{self.name}: {self.age}'

X = Person('Bob', 40)
print(X.name)                               # Dostęp z zewnątrz jest sprawdzany
X.name = 'Sue'
print(X.name)
X + 10
print(X)

try:    t = X.age                           # NIE POWIEDZIE SIĘ, o ile nie mamy "python –O"
except: print(sys.exc_info()[1])
try:    X.age = 999                         # Jak wyżej
except: print(sys.exc_info()[1])

print('---------------------------------------------------------')
# Test 2: nazwy prywatne, jeśli niepubliczne
# Operatory zdefiniowane w klasie BuiltinMixin muszą być nieprywatne lub publiczne

@Public('name', '__add__', '__str__', '__coerce__')
class Person:
    def __init__(self, name, age):
        self.name = name
        self.age  = age
    def __add__(self, N):
        self.age += N                       # Wbudowane operatory przechwytywane z wykorzystaniem klas mieszanych 
    def __str__(self):
        return f'{self.name}: {self.age}'

X = Person('bob', 40)                       # X to onInstance
print(X.name)                               # onInstance osadza Person
X.name = 'sue'
print(X.name)
X + 10
print(X)

try:    t = X.age                           # NIE POWIEDZIE SIĘ, o ile nie mamy "python –O"
except: print(sys.exc_info()[1])
try:    X.age = 999                         # Jak wyżej
except: print(sys.exc_info()[1])

