# quickstart5.py - listing 3.38
import time
import asyncio
from concurrent.futures import ThreadPoolExecutor as Executor

async def make_coro(future):
  try:
    return await future
  except asyncio.CancelledError:
    return await future

async def main():
  loop = asyncio.get_running_loop()
  future = loop.run_in_executor(None, blocking)
  asyncio.create_task(make_coro(future))
  print(f'{time.ctime()} Witaj!')
  await asyncio.sleep(1.0)
  print(f'{time.ctime()} Żegnaj!')


def blocking():
  time.sleep(2.0)
  print(f"{time.ctime()} Witamy z poziomu wątku!")

try:
  asyncio.run(main())
except KeyboardInterrupt:
  print('Cześć!')
