# shell_signal02b.py - listing 3.35
import asyncio
from signal import SIGINT, SIGTERM

async def main():
  loop = asyncio.get_running_loop()
  for sig in (SIGTERM, SIGINT):
    loop.add_signal_handler(sig, handler, sig)

  try:
    while True:
      print('<Twoja aplikacja działa...>')
      await asyncio.sleep(1)
  except asyncio.CancelledError:
    for i in range(3):
      print('<Twoja aplikacja jest zamykana...>')
      await asyncio.sleep(1)


def handler(sig):
  loop = asyncio.get_running_loop()
  for task in asyncio.all_tasks(loop=loop):
    task.cancel()
  print('Odebrano sygnał: {sig!s}, zamykamy aplikację.')
  loop.remove_signal_handler(SIGTERM)
  loop.add_signal_handler(SIGINT, lambda: None)
  
if __name__ == '__main__':
  asyncio.run(main())
