# mq_client_listen.py - listing 4.3
import asyncio
import argparse, uuid
from msgproto import read_msg, send_msg

async def main(args):
  me = uuid.uuid4().hex[:8]
  print(f'Uruchamiam klienta {me}')
  reader, writer = await asyncio.open_connection(
    args.host, args.port)
  print(f'Jestem klientem {writer.get_extra_info("sockname")}.')
  channel = args.listen.encode()
  await send_msg(writer, channel)
  try:
    while data := await read_msg(reader):
      print(f'Komunikat odebrany przez {me}: {data[:20]}')
    print('Połączenie zostało zakończone.')
  except asyncio.IncompleteReadError:
    print('Serwer został zamknięty.')
  finally:
    writer.close()
  await writer.wait_closed()

if __name__ == '__main__':
  parser = argparse.ArgumentParser()
  parser.add_argument('--host', default='localhost')
  parser.add_argument('--port', default=25000)
  parser.add_argument('--listen', default='/topic/foo')
  try:
    asyncio.run(main(parser.parse_args()))
  except KeyboardInterrupt:
    print('Cześć!')
