# Uwaga - to nie jest program, tylko kod wpisywany
# w interaktywnej sesji w środowisku Pythona!

import asyncio
from contextlib import suppress
async def main(f: asyncio.Future):
  await asyncio.sleep(1)
  try:
    f.set_result('Zakończyłam działanie.')
  except RuntimeError as e:
    print(f'To już nie jest dozwolne: {e}')
  f.cancel()

loop = asyncio.get_event_loop()
fut = asyncio.Task(asyncio.sleep(1_000_000))
print(fut.done())
loop.create_task(main(fut))
with suppress(asyncio.CancelledError):
  loop.run_until_complete(fut)

print(fut.done())
print(fut.cancelled())
