import json
import pandas as pd
data = [
 {"NumPrac":9001,"Wynagrodz":3000},
 {"NumPrac":9002,"Wynagrodz":2800},
 {"NumPrac":9003,"Wynagrodz":2500}
]
json_data = json.dumps(data)
salary = pd.read_json(json_data)
salary = salary.set_index('NumPrac')
print(salary) 

data = [['9001','Piotr Rabanowicz', 'sprzedaż'],
        ['9002','Joanna Broniewicz', 'sprzedaż'],
        ['9003','Tomasz Wielgus', 'sprzedaż']]
emps = pd.DataFrame(data, columns = ['NumPrac', 'Personalia', 'Stanowisko']) 
column_types = {'NumPrac': int, 'Personalia': str, 'Stanowisko': str} 
emps = emps.astype(column_types)
emps = emps.set_index('NumPrac')
print(emps)

emps_salary = emps.join(salary)
print(emps_salary)

new_emp = pd.Series({'Personalia': 'Jan Twardowski', 'Stanowisko': 'sprzedaż'}, name = 9004)
emps = emps.append(new_emp)

emps_salary = emps.join(salary, how = 'inner')
print(emps_salary)

new_salary = pd.Series({'Wynagrodz': 2400}, name = 9006)
salary = salary.append(new_salary)

emps_salary = emps.join(salary, how = 'inner')
print(emps_salary)

emps_salary = emps.join(salary, how = 'outer')
print(emps_salary)
