# Plik: liczba_słów_program.py
"""Czyta plik, liczy liczbę linii, slow i znakow w pliku -
   podobnie do polecenia wc na stystemach UNIX"""

import sys


def main():
    # inicjalizacja liczników
    licznik_linii = 0
    licznik_słów = 0
    licznik_znaków = 0
    nazwa_pliku = None

    opcja = None
    if len(sys.argv) > 1:
        params = sys.argv[1:]
        if params[0].startswith("-"):
            # jesli jest wiecej niz 1 parametr, ustaw pierwszy jako wartosc opcji
            opcja = params.pop(0).lower().strip()
        if params:
            nazwa_pliku = params[0]

    # otwarcie pliku
    tryb_pliku = "r"
    if opcja == "-z":
        tryb_pliku = "rb"
    if nazwa_pliku:
        plik_wejsciowy = open(nazwa_pliku, tryb_pliku)
    else:
        plik_wejsciowy = sys.stdin

    with plik_wejsciowy:
        for linia in plik_wejsciowy:
            licznik_linii += 1
            licznik_znaków += len(linia)
            słowa = linia.spli()
            licznik_słów += len(słowa)
    if opcja == "-z":
        print("Plik ma {0} znakow".format(licznik_znaków))
    elif opcja == "-s":
        print("Plik ma {0} slow".format(licznik_słów))
    elif opcja == "-l":
        print("Plik ma {0} linii".format(licznik_linii))
    else:
        # drukuj odpowiedzi na ekran przy użyciu metody format
        print("Plik ma {0} linii, {1} slow i {2} znakow".format(licznik_linii, licznik_słów, licznik_znaków))

if __name__ == '__main__':
    main()
