import argparse
from google.cloud import language
from google.cloud import translate_v2 as translate
from google.cloud.language import enums
from google.cloud.language import types


def main(image_file):
    content = image_file.read()
    print(f'Text: {content}')
    document = types.Document(content=content,
                              type=enums.Document.Type.PLAIN_TEXT)

    client = language.LanguageServiceClient()

    response = client.analyze_sentiment(document=document)
    lang = response.language
    print(f'Język: {lang}')
    sentiment = response.document_sentiment
    score = sentiment.score
    magnitude = sentiment.magnitude
    print(f'Typ nastawienia (pozytywne czy negatywne): {score}')
    print(f'Siła nastawienia: {magnitude}')
    if lang != 'en':
        # Tłumaczenie na angielski.
        translate_client = translate.Client()
        response = translate_client.translate(content, target_language='en')
        print('PO ANGIELSKU')
        print(response['translatedText'])


if __name__ == '__main__':
    parser = argparse.ArgumentParser()
    parser.add_argument(dest='input', type=argparse.FileType('r'),
                        help='Wejściowy tekst')
    args = parser.parse_args()
    main(args.input)
