import time
import telepot
from telepot.loop import MessageLoop
from telepot.delegate import per_chat_id, create_open, pave_event_space


TOKEN = '<TWÓJ TOKEN>'


# Definiowanie informacji zwracanych w reakcji na polecenia.
def get_help():
    msg = '''
    Użyj jednego z następujących poleceń:
        pomoc - wyświetla tę pomoc
        oferta - wyświetla promocje z tego tygodnia
        wydarzenia - wyświetla wydarzenia z tego tygodnia
    '''
    return msg


def get_offers():
    msg = '''
    W tym tygodniu czekają na Ciebie fantastyczne promocje:
        20% rabatu na produkty plażowe
        15% rabatu, jeśli wydasz więcej niż 200 złotych
    '''
    return msg


def get_events():
    msg = '''
    Dołącz do nas na fantastycznej imprezie w ten czwartek w Krakowie!
    '''
    return msg


COMMANDS = {
    'pomoc': get_help,
    'oferta': get_offers,
    'wydarzenia': get_events,
}


class MarketingBot(telepot.helper.ChatHandler):

    def open(self, initial_msg, seed):
        self.sender.sendMessage(get_help())
        # Zapobiega wywołaniu on_message() dla pierwszej wiadomości.
        return True

    def on_chat_message(self, msg):
        # Jeśli przesłane dane nie są tekstowe, należy zwrócić błąd.
        content_type, chat_type, chat_id = telepot.glance(msg)

        if content_type != 'text':
            self.sender.sendMessage("Nie rozumiem polecenia. "
                                    "Wpisz 'pomoc', aby wyświetlić opcje.")
            return

        # Sprawia, że wielkość znaków w poleceniach nie jest istotna.
        command = msg['text'].lower()
        if command not in COMMANDS:
            self.sender.sendMessage("Nie rozumiem polecenia. "
                                    "Wpisz 'pomoc', aby wyświetlić opcje.")
            return

        message = COMMANDS[command]()
        self.sender.sendMessage(message)

    def on_idle(self, event):
        self.close()

    def on_close(self, event):
        # Tu dodaj potrzebne operacje porządkujące.
        pass


# Tworzenie i uruchamianie bota.
bot = telepot.DelegatorBot(TOKEN, [
    pave_event_space()(
        per_chat_id(), create_open, MarketingBot, timeout=10),
])
MessageLoop(bot).run_as_thread()
print('Oczekiwanie...')

while 1:
    time.sleep(10)
