﻿<html>
<head><title>WURFL Transcoder Identification</title></head>
<body>
<?php
// Ten fragment kodu określa, czy dane żądanie zostało poddane procesowi transkodowania, a w razie
// możliwości dodatkowo identyfikuje źródłowe urządzenie mobilne.

// Inicjalizuje bazę danych WURFL:
require_once('wurfl-php-1.r1/WURFL/WURFLManagerProvider.php');
$wurflConfigFile =
    "/home/webuser/learnto.mobi/html/books/bmwd/04/wurfl/wurflconfig.xml";
$wurflManager = WURFL_WURFLManagerProvider::getWURFLManager($wurflConfigFile);

// Identyfikuje urządzenie, które wygenerowało dane żądanie protokołu HTTP
// (na tym etapie nie bierzemy pod uwagę ewentualnego transkodowania):
$device = $wurflManager->getDeviceForHttpRequest($_SERVER);

// Odnajduje identyfikator klienta w potencjalnie transkodowanym żądaniu:
$userAgent = null;

// Sprawdza, czy baza danych WURFL identyfikuje to urządzenie jako transkoder:
$isTranscoder = $device->getCapability('is_transcoder');
if ($isTranscoder == "true") {
    // Uzyskuje identyfikator klienta z nagłówka wskazanego przez bazę danych WURFL:
    $headerName = $device->getCapability('transcoder_ua_header');
    if ($headerName != null) {
        // Dostosowuje nazwę nagłówka do formatu wymaganego przez PHP:
        $headerName = str_replace(' ', '_', $headerName);
        $headerName = str_replace('-', '_', $headerName);
        $headerName = strtoupper($headerName);
        // Jeśli w tym nagłówku znaleziono identyfikator klienta, używamy tego identyfikatora:
        if (isset($_SERVER['HTTP_' . $headerName])) {
            $userAgent = $_SERVER['HTTP_' . $headerName];
        }
    }
}

// Sprawdza wartość ewentualnego nagłówka X-Device-User-Agent.
// Jeśli taka wartość istnieje, należy traktować ją jako identyfikator urządzenia będącego źródłem żądania.
if ($userAgent == null) {
    if (isset($_SERVER['HTTP_X_DEVICE_USER_AGENT'])) {
        // Zapisuje identyfikator urządzenia źródłowego.
        $userAgent = $_SERVER['HTTP_X_DEVICE_USER_AGENT'];
    }
}

// Jeśli nie możemy odnaleźć transkodowanego identyfikatora klienta, przyjmujemy, że żądanie nie było transkodowane:
if ($userAgent == null) {
    $userAgent = $_SERVER['HTTP_USER_AGENT'];
}

// Uzyskuje obiekt źródłowego urządzenia mobilnego na podstawie wartości identyfikatora klienta
// znalezionego w jednym z wielu nagłówków:
$device = $wurflManager->getDeviceForUserAgent($userAgent);

?>
<ul>
<li>Transcoded? <?= ($reqIsTranscoded == true) ?></li>
<li>Request UA: <?= $_SERVER['HTTP_USER_AGENT'] ?></li>
<li>Device UA: <?= $userAgent ?></li>
<li>Device Model: <?= $device->getCapability('model_name') ?></li>
</ul>
</body>
</html>

