//
//  Monster.swift
//  MonsterTown
//
//  Created by Robert Górczyński on 14/09/16.
//  Copyright © 2016 Robert Górczyński. All rights reserved.
//

import Foundation

class Monster {
    static let isTerrifying = true
    class var spookyNoise: String {
        return "Grrr"
    }
    var town: Town?
    var name: String
    
    var victimPool: Int {
        get {
            return town?.population ?? 0
        }
        set(newVictimPool) {
            town?.population = newVictimPool
        }
    }
    
    required init(town: Town?, monsterName: String) {
        self.town = town
        name = monsterName
    }

    func terrorizeTown() {
        if town != nil {
            print("\(name) terroryzuje miasto!")
        } else {
            print("\(name) jeszcze nie znalazł miasta do terroryzowania...")
        }
    }
}
