//: Playground - noun: a place where people can play

import Cocoa

func greetName(name: String, withGreeting greeting: String) -> String {
    return "\(greeting) \(name)"
}

let personalGreeting = greetName(name: "Mateusz", withGreeting: "Witaj,")
print(personalGreeting)

func greetingForName(name: String) -> (String) -> String {
    func greeting(greeting: String) -> String {
        return "\(greeting) \(name)"
    }
    return greeting
}

let greeterFunction = greetingForName(name: "Mateusz")
let theGreeting = greeterFunction("Witaj,")
print(theGreeting)

func greeting(greeting: String, name: String) -> String {
    return "\(greeting) \(name)"
}

let friendlyGreeting = greeting(greeting: "Witaj,", name: "Mateusz")
print(friendlyGreeting)

struct Person {
    var firstName = "Mateusz"
    var lastName = "Matuszewski"
    mutating func changeName(fn: String, ln: String) {
        firstName = fn
        lastName = ln
    }
}

var p = Person()
p.changeName(fn: "Jan", ln: "Kowalski")
p.firstName // Jan.
