"""
Programowanie obiektowe w Pythonie 3

Rozdział 14., Współbieżność
"""
import math
import random
from threading import Thread, Lock
import time

THE_ORDERS = [
    "Reuben",
    "Szynka z serem",
    "Monte Cristo",
    "Tuńczyk na gorąco",
    "Cuban",
    "Griloway ser",
    "Francuski dip",
    "BLT",
]


class Chef(Thread):
    def __init__(self, name: str) -> None:
        super().__init__(name=name)
        self.total = 0

    def get_order(self) -> None:
        self.order = THE_ORDERS.pop(0)

    def prepare(self) -> None:
        """Symulacja wykonania złożonych operacji przy użyciu DUŻYCH obliczeń"""
        start = time.monotonic()
        target = start + 1 + random.random()
        for i in range(1_000_000_000):
            self.total += math.factorial(i)
            if time.monotonic() >= target:
                break
        print(f"{time.monotonic():.3f} {self.name} przygotował {self.order}")

    def run(self) -> None:
        while True:
            try:
                self.get_order()
                self.prepare()
            except IndexError:
                break  # Brak dalszych zamówień


Mo = Chef("Michał")
Constantine = Chef("Konstanty")

if __name__ == "__main__":
    random.seed(42)
    Mo.start()
    Constantine.start()
