# Programowanie obiektowe w Pythonie 3

## Uwagi 

Umieszczone w katalogach 'docs' pliki '*.uml' zawierające diagramy UML oraz 
wygenerowane na ich podstawie pliki '*.png' nie zostały spolonizowane.

## Testowanie przykładów 

W przypadku testowania przykładów dołączonych do książki z wiersza poleceń, testy należy uruchamiać z poziom podkatalogów poszczególnych rozdziałów.

W pierwszej kolejności należy ustawić wartość zmiennej środowiskowej ```PYTHONPATH``` i podać w niej ścieżkę (względną lub bezwzględną) dostępu do  katalogu ```src```.

```
SET PYTHONPATH=C:\ścieżka\do\katalogu\src
```

Do testowania plików ```*.py``` z kodami źródłowymi przykładów, umieszczonych w podkatalogu 'src', można użyć polecenia:
```
python -m doctest -o ELLIPSIS -o NORMALIZE_WHITESPACE -v src\<nazwapliku.py>
```

W podobny sposób można testować pliki '*.md' umieszczone w podkatalogu `docs`:
```
python -m doctest -o ELLIPSIS -o NORMALIZE_WHITESPACE -v docs\<nazwapliku.md>
```

Do testowania plików z testami umieszczonych w katalogu 'tests' należy użyć polecenia:
```
python -m pytest tests\<nazwapliku.py>
```

Do tych poleceń można dodać opcję `-v`, by wyświetlać szczegółowe informacje o wynikach testów.