"""
Programowanie obiektowe w Pythonie 3

Rozdział 13., Testowanie oprogramowania obiektowego
"""
import unittest
import sys


class SkipTests(unittest.TestCase):
    @unittest.expectedFailure
    def test_fails(self) -> None:
        self.assertEqual(False, True)

    @unittest.skip("Ten test jest bezużyteczny")
    def test_skip(self) -> None:
        self.assertEqual(False, True)

    @unittest.expectedFailure  # Usuń, by sprawdzić efekty testu numeru wersji Pythona
    @unittest.skipIf(sys.version_info.minor == 8, "Test nieudany w Pythonie 3.8")
    def test_skipif(self) -> None:
        self.assertEqual(False, True)

    @unittest.skipUnless(sys.platform.startswith("linux"), "Test nieudany w systemie innym niż Linux")
    def test_skipunless(self) -> None:
        self.assertEqual(False, True)


if __name__ == "__main__":
    unittest.main()
