"""
Programowanie obiektowe w Pythonie 3

Rozdział 14., Współbieżność
"""
from __future__ import annotations
import argparse
import signal
import subprocess
import time
import sys


def main(clients: int = 10) -> None:
    if sys.platform == "win32":
        platform_flags = subprocess.CREATE_NEW_PROCESS_GROUP
    else:
        platform_flags = 0
    server = subprocess.Popen(
        ["python", "src/log_catcher.py"], creationflags=platform_flags
    )
    # Czekamy 100 ms na uruchomienie serwera
    time.sleep(0.100)
    # Sprawdzamy czy serwer nie uległ awari podczas wcześniejszych testów
    assert server.poll() is None, f"Nie udało się uruchomić serwera"
    workers = [
        subprocess.Popen(["python", "src/remote_logging_app.py"])
        for i in range(clients)
    ]
    print(f"*** URUCHOMIONO {clients} PODPROCESÓW ROCZYCH ***")
    for w in workers:
        w.wait()
        print(f"podproces {w.pid} zakończony {w.returncode}")
    print(f"*** ZAKOŃCZONO {clients} PODPROCESÓW ROBOCZYCH ***")
    # Give the server 100 ms to finish processing
    time.sleep(0.100)

    if sys.platform == "win32":
        server.send_signal(signal.CTRL_BREAK_EVENT)
    else:
        server.terminate()
    server.wait()
    print(f"zakończono działanie serwera {server.returncode}")


def get_options(argv: list[str] = sys.argv[1:]) -> argparse.Namespace:
    parser = argparse.ArgumentParser()
    parser.add_argument("workers", nargs="?", type=int, default=1)
    options = parser.parse_args()
    return options


if __name__ == "__main__":
    options = get_options()
    main(options.workers)
