"""
Programowanie obiektowe w Pythonie 3

Rozdział 7., Struktury danych w Pythonie
"""
from __future__ import annotations
import sys


def letter_frequency(sentence: str) -> dict[str, int]:
    frequencies: dict[str, int] = {}
    for letter in sentence:
        frequency = frequencies.setdefault(letter, 0)
        frequencies[letter] = frequency + 1
    return frequencies


test_lf_1 = """
>>> txt = "szybki brązowy lis przeskoczył nad leniwym psem"
>>> letter_frequency(txt)
{'s': 4, 'z': 4, 'y': 4, 'b': 2, 'k': 2, 'i': 3, ' ': 6, 'r': 2, 'ą': 1, 'o': 2, 'w': 2, 'l': 2, 'p': 2, 'e': 3, 'c': 1, 'ł': 1, 'n': 2, 'a': 1, 'd': 1, 'm': 2}

"""

from collections import defaultdict


def letter_frequency_2(sentence: str) -> defaultdict[str, int]:
    frequencies: defaultdict[str, int] = defaultdict(int)
    for letter in sentence:
        frequencies[letter] += 1
    return frequencies


test_lf_2 = """
>>> txt = "szybki brązowy lis przeskoczył nad leniwym psem"
>>> letter_frequency_2(txt)
defaultdict(<class 'int'>, {'s': 4, 'z': 4, 'y': 4, 'b': 2, 'k': 2, 'i': 3, ' ': 6, 'r': 2, 'ą': 1, 'o': 2, 'w': 2, 'l': 2, 'p': 2, 'e': 3, 'c': 1, 'ł': 1, 'n': 2, 'a': 1, 'd': 1, 'm': 2})

>>> import collections
>>> lf = collections.defaultdict(lambda: "Unknown", letter_frequency_2(txt))
>>> lf["z"]
4
>>> lf[":"]
'Unknown'

"""

from collections import Counter


def letter_frequency_3(sentence: str) -> Counter[str]:
    return Counter(sentence)


test_lf_3 = """
>>> txt = "szybki brązowy lis przeskoczył nad leniwym psem"
>>> letter_frequency_3(txt)
Counter({' ': 6, 's': 4, 'z': 4, 'y': 4, 'i': 3, 'e': 3, 'b': 2, 'k': 2, 'r': 2, 'o': 2, 'w': 2, 'l': 2, 'p': 2, 'n': 2, 'm': 2, 'ą': 1, 'c': 1, 'ł': 1, 'a': 1, 'd': 1})

"""


__test__ = {name: case for name, case in globals().items() if name.startswith("test_")}
