# Practical Natural Language Processing
## A Comprehensive Guide to Building Real-World NLP Systems
[Sowmya Vajjala](https://www.linkedin.com/in/sowmya-vajjala-2a38734/), [Bodhisattwa P. Majumder](http://www.majumderb.com/), [Anuj Gupta](https://www.linkedin.com/in/anujgupta-82/), [Harshit Surana](http://harshitsurana.com/)

**Endorsed by:**
[Zachary Lipton](http://zacklipton.com/), [Sebastian Ruder](https://ruder.io/), [Marc Najork](http://marc.najork.org/), [Monojit Choudhury](https://www.microsoft.com/en-us/research/people/monojitc/), [Vinayak Hegde](https://www.linkedin.com/in/vinayakh/), [Mengting Wan](https://mengtingwan.github.io/), [Siddharth Sharma](https://www.linkedin.com/in/siddharth-sharma-31140210/), & [Ed Harris](https://www.linkedin.com/in/e10is/)
**Foreword by:** [Julian McAuley](https://cseweb.ucsd.edu/~jmcauley/)


Homepage: [www.practicalnlp.ai](http://www.practicalnlp.ai)
Published by [O'Reilly Media, 2020](http://shop.oreilly.com/product/0636920262329.do)

-----------------------------------------------------------------------------------
# Book Structure

![figure](https://github.com/practical-nlp/practical-nlp-figures/raw/master/figures/P-1.png)



```
Please note that the code repository is still under development and review.

All the notebooks will be crystalized in the coming months. 

The notebooks have been tested on an ubuntu machine running python 3.6. 

Currently, we are using TF1.x. We will migrate to TF2.x in the coming months.  
```
🚩 Details of the repository roadmap could be found [here](roadmap.md)

-----------------------------------------------------------------------------------

<!-- ![](http://check-server.in/book/images/book.png =250x250)](http://practicalnlp.ai) -->

### Open the repository in Google Colab: [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/practical-nlp/practical-nlp/blob/master)

### Open the repository in Jupyter nbviewer: [![Open in nbviewer](https://user-images.githubusercontent.com/2791223/29387450-e5654c72-8294-11e7-95e4-090419520edb.png)](https://nbviewer.jupyter.org/github/practical-nlp/practical-nlp/tree/master/)

### Chapterwise folders:

  * [Chapter 1: NLP: A Primer](https://github.com/practical-nlp/practical-nlp/tree/master/Ch1) (only figures & outline)

  * [Chapter 2: NLP Pipeline](https://github.com/practical-nlp/practical-nlp/tree/master/Ch2) 

  * [Chapter 3: Text Representation](https://github.com/practical-nlp/practical-nlp/tree/master/Ch3) 

  * [Chapter 4: Text Classification](https://github.com/practical-nlp/practical-nlp/tree/master/Ch4) 
  
  * [Chapter 5: Information Extraction](https://github.com/practical-nlp/practical-nlp/tree/master/Ch5) 
  
  * [Chapter 6: ChatBots](https://github.com/practical-nlp/practical-nlp/tree/master/Ch6) 
  
  * [Chapter 7: Topics in Brief](https://github.com/practical-nlp/practical-nlp/tree/master/Ch7) 
  
  * [Chapter 8: Social Media](https://github.com/practical-nlp/practical-nlp/tree/master/Ch8) 
    
  * [Chapter 9: E-commerce and Retail ](https://github.com/practical-nlp/practical-nlp/tree/master/Ch9)

  * [Chapter 10: Healthcare, Finance and Law](https://github.com/practical-nlp/practical-nlp/tree/master/Ch10) 
    
  * [Chapter 11: End-to-End NLP Process](https://github.com/practical-nlp/practical-nlp/tree/master/Ch11)


**Contributors to Codebase:**

* [Varun Purushotham](https://www.linkedin.com/in/varunp2k/)
* [Kartikay Bagla](https://www.linkedin.com/in/kartikay-bagla-60638a167/)
* [Jitin Kapila](https://www.linkedin.com/in/jitinkapila/)
* [Vishal Gupta](https://www.linkedin.com/in/vishalg8897/)
* [Taranjeet Singh](https://www.linkedin.com/in/taranjeet7114/)
* [Shreyans Dhankhar](https://www.linkedin.com/in/shreyans-dhankhar-501b88118/)
* [Kumarjit Pathak](https://www.linkedin.com/in/kumarjitpathak/)
* [Ernest Kirubakaran Selvaraj](https://www.linkedin.com/in/ernest-s-kirubakaran/)
* [Ayush Datta](https://www.linkedin.com/in/ayushdatta/)
* [Rui Shu](https://www.linkedin.com/in/rui-shu/)
* [Nachiketh Suresh](https://www.linkedin.com/in/nachiketh-suresh-a4955411/)
* [Jatin Papreja](https://www.linkedin.com/in/jatin-papreja-71982bb9/)
* [Kumar Apurva](https://www.linkedin.com/in/kumar-apurva-000b38197/)
* [Sukeerat Goindi](https://github.com/sukeeratsg)


**Found a Bug?**

If the bug is in book text, please enter a errata here: 
[https://www.oreilly.com/catalog/errata.csp?isbn=0636920262329](https://www.oreilly.com/catalog/errata.csp?isbn=0636920262329) 

If the bug is in the codebase:
Great! Please read [this](https://github.com/practical-nlp/practical-nlp/edit/master/Contributing.md) how can you help us improve the codebase
