var express = require('express');
var BoardModel = require("./BoardModel");
var nodemailer = require("nodemailer");
var fs = require("fs");

var loggerStream;
var app = express.createServer();

// Odkomentuj poniższy wiersz, aby sprawdzić działanie aplikacji w środowisku produkcyjnym
// app.set("env", "production");

// Wszystkie środowiska mają takie same ustawienia dla widoków.
app.configure(function() {
    app.set('views', __dirname + '/views');
    app.set('view engine', 'ejs');
});

// W środowisku produkcyjnym chcemy zapisywać logi do plików w czytelnym formacie.
app.configure("production", function() {
    loggerStream = fs.createWriteStream(__dirname + "/node.log", { flags: 'a'});
    app.use(express.logger({
        format: "default",
        stream: loggerStream
    }));
});

// W trakcie tworzenia aplikacji w ogóle nie używamy logów.

// Główny stos jest identyczny dla obu środowisk.
app.configure(function() {
    app.use(express.cookieParser());
    app.use(express.session({ secret: "gameserversession" }));
    app.use(app.router);
    app.use(express.static(__dirname + '/public'));
});

// Zapisz logi i ukryj stronę - tylko na produkcji
app.configure("production", function() {
    app.use(function(err, req, res, next) {
            loggerStream.write(err.stack);
            next(err);
        }
    );

    // Wyślij e-mail do zespołu programistów.
    app.use(function(err, req, res, next) {
        var transport = nodemailer.createTransport("SMTP", {
            service: "Gmail",
            auth: {
                user: "juriy.bura@gmail.com",
                pass: "water;00"
            }
        });
        transport.sendMail({
            from : "node@juriy.com", // od
            to : "juriy.bura@gmail.com", // do
            subject : "Error report", // temat
            body: "We got error here!\n" + err.stack // opis błędu
        }, function(error, responseStatus){
            if(!error){
                console.log(responseStatus.message); // odpowiedź z serwera
            } else {
                console.log("ERROR " + error);
            }
        });
        next(err);
    });

    // Wyrenderuj stronę dla użytkownika
    app.use(function(err, req, res, next) {
        res.render("error", {layout: false});
    });
});

// W trakcie tworzenia aplikacji możesz korzystać ze zwykłej obsługi komunikatów.
app.configure("development", function() {
    app.use(express.errorHandler());
});

var board = new BoardModel();
board.makeTurn(2);
board.makeTurn(3);

app.get('/', function(req, res) {
    if (!req.session.totalTurns) {
        req.session.totalTurns = 0;
    }

    var turn = req.query["turn"];
    if (!isNaN(turn)) {
        board.makeTurn(turn);
        req.session.totalTurns++;
    }

    var err = req.query["err"];
    if (err) {
        foo.bar = baz;
    }

    res.render('board', {
        BoardModel: BoardModel,
        board: board,
        totalTurns: req.session.totalTurns,
        layout: false
    });
});

app.listen(80); 
