/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import java.util.List;
import org.apache.cordova.api.CordovaInterface;
import org.apache.cordova.api.Plugin;
import org.apache.cordova.api.PluginResult;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CompassListener
extends Plugin
implements SensorEventListener {
    public static int STOPPED = 0;
    public static int STARTING = 1;
    public static int RUNNING = 2;
    public static int ERROR_FAILED_TO_START = 3;
    public long TIMEOUT = 30000L;
    int status;
    float heading = 0.0f;
    long timeStamp = 0L;
    long lastAccessTime;
    int accuracy;
    private SensorManager sensorManager;
    Sensor mSensor;

    public CompassListener() {
        this.setStatus(STOPPED);
    }

    public void setContext(CordovaInterface cordova) {
        super.setContext(cordova);
        this.sensorManager = (SensorManager)cordova.getActivity().getSystemService("sensor");
    }

    public PluginResult execute(String action, JSONArray args, String callbackId) {
        PluginResult.Status status = PluginResult.Status.OK;
        String result = "";
        try {
            if (action.equals("start")) {
                this.start();
            } else if (action.equals("stop")) {
                this.stop();
            } else {
                if (action.equals("getStatus")) {
                    int i = this.getStatus();
                    return new PluginResult(status, i);
                }
                if (action.equals("getHeading")) {
                    if (this.status != RUNNING) {
                        int r = this.start();
                        if (r == ERROR_FAILED_TO_START) {
                            return new PluginResult(PluginResult.Status.IO_EXCEPTION, ERROR_FAILED_TO_START);
                        }
                        long timeout = 2000L;
                        while (this.status == STARTING && timeout > 0L) {
                            timeout -= 100L;
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                        if (timeout == 0L) {
                            return new PluginResult(PluginResult.Status.IO_EXCEPTION, ERROR_FAILED_TO_START);
                        }
                    }
                    return new PluginResult(status, this.getCompassHeading());
                }
                if (action.equals("setTimeout")) {
                    this.setTimeout(args.getLong(0));
                } else {
                    if (action.equals("getTimeout")) {
                        long l = this.getTimeout();
                        return new PluginResult(status, l);
                    }
                    return new PluginResult(PluginResult.Status.INVALID_ACTION);
                }
            }
            return new PluginResult(status, result);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return new PluginResult(PluginResult.Status.JSON_EXCEPTION);
        }
    }

    public boolean isSynch(String action) {
        if (action.equals("getStatus")) {
            return true;
        }
        return action.equals("getHeading") ? this.status == RUNNING : action.equals("getTimeout");
    }

    public void onDestroy() {
        this.stop();
    }

    public int start() {
        if (this.status == RUNNING || this.status == STARTING) {
            return this.status;
        }
        List list = this.sensorManager.getSensorList(3);
        if (list != null && list.size() > 0) {
            this.mSensor = (Sensor)list.get(0);
            this.sensorManager.registerListener((SensorEventListener)this, this.mSensor, 3);
            this.lastAccessTime = System.currentTimeMillis();
            this.setStatus(STARTING);
        } else {
            this.setStatus(ERROR_FAILED_TO_START);
        }
        return this.status;
    }

    public void stop() {
        if (this.status != STOPPED) {
            this.sensorManager.unregisterListener((SensorEventListener)this);
        }
        this.setStatus(STOPPED);
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    public void onSensorChanged(SensorEvent event) {
        float heading = event.values[0];
        this.timeStamp = System.currentTimeMillis();
        this.heading = heading;
        this.setStatus(RUNNING);
        if (this.timeStamp - this.lastAccessTime > this.TIMEOUT) {
            this.stop();
        }
    }

    public int getStatus() {
        return this.status;
    }

    public float getHeading() {
        this.lastAccessTime = System.currentTimeMillis();
        return this.heading;
    }

    public void setTimeout(long timeout) {
        this.TIMEOUT = timeout;
    }

    public long getTimeout() {
        return this.TIMEOUT;
    }

    private void setStatus(int status) {
        this.status = status;
    }

    private JSONObject getCompassHeading() {
        JSONObject obj = new JSONObject();
        try {
            obj.put("magneticHeading", (double)this.getHeading());
            obj.put("trueHeading", (double)this.getHeading());
            obj.put("headingAccuracy", 0);
            obj.put("timestamp", this.timeStamp);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return obj;
    }
}

