/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova.api;

import android.content.Intent;
import android.content.res.XmlResourceParser;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.cordova.CordovaWebView;
import org.apache.cordova.api.CordovaInterface;
import org.apache.cordova.api.IPlugin;
import org.apache.cordova.api.LOG;
import org.apache.cordova.api.PluginEntry;
import org.apache.cordova.api.PluginResult;
import org.json.JSONArray;
import org.json.JSONException;
import org.xmlpull.v1.XmlPullParserException;

public class PluginManager {
    private static String TAG = "PluginManager";
    private final HashMap<String, PluginEntry> entries = new HashMap();
    private final CordovaInterface ctx;
    private final CordovaWebView app;
    private boolean firstRun;
    protected HashMap<String, String> urlMap = new HashMap();

    public PluginManager(CordovaWebView app, CordovaInterface ctx) {
        this.ctx = ctx;
        this.app = app;
        this.firstRun = true;
    }

    public void init() {
        LOG.d(TAG, "init()");
        if (this.firstRun) {
            this.loadPlugins();
            this.firstRun = false;
        } else {
            this.onPause(false);
            this.onDestroy();
            this.clearPluginObjects();
        }
        this.startupPlugins();
    }

    public void loadPlugins() {
        int id = this.ctx.getActivity().getResources().getIdentifier("config", "xml", this.ctx.getActivity().getPackageName());
        if (id == 0) {
            id = this.ctx.getActivity().getResources().getIdentifier("plugins", "xml", this.ctx.getActivity().getPackageName());
            LOG.i(TAG, "Using plugins.xml instead of config.xml.  plugins.xml will eventually be deprecated");
        }
        if (id == 0) {
            this.pluginConfigurationMissing();
            return;
        }
        XmlResourceParser xml = this.ctx.getActivity().getResources().getXml(id);
        int eventType = -1;
        String service = "";
        String pluginClass = "";
        boolean onload = false;
        PluginEntry entry = null;
        while (eventType != 1) {
            if (eventType == 2) {
                String strNode = xml.getName();
                if (strNode.equals("plugin")) {
                    service = xml.getAttributeValue(null, "name");
                    pluginClass = xml.getAttributeValue(null, "value");
                    onload = "true".equals(xml.getAttributeValue(null, "onload"));
                    entry = new PluginEntry(service, pluginClass, onload);
                    this.addService(entry);
                } else if (strNode.equals("url-filter")) {
                    this.urlMap.put(xml.getAttributeValue(null, "value"), service);
                }
            }
            try {
                eventType = xml.next();
            }
            catch (XmlPullParserException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void clearPluginObjects() {
        for (PluginEntry entry : this.entries.values()) {
            entry.plugin = null;
        }
    }

    public void startupPlugins() {
        for (PluginEntry entry : this.entries.values()) {
            if (!entry.onload) continue;
            entry.createPlugin(this.app, this.ctx);
        }
    }

    public String exec(String service, final String action, final String callbackId, String jsonArgs, boolean async) {
        PluginResult cr = null;
        boolean runAsync = async;
        try {
            final JSONArray args = new JSONArray(jsonArgs);
            final IPlugin plugin = this.getPlugin(service);
            if (plugin != null) {
                boolean bl = runAsync = async && !plugin.isSynch(action);
                if (runAsync) {
                    Thread thread = new Thread(new Runnable(){

                        public void run() {
                            try {
                                PluginResult cr = plugin.execute(action, args, callbackId);
                                int status = cr.getStatus();
                                if (status != PluginResult.Status.NO_RESULT.ordinal() || !cr.getKeepCallback()) {
                                    if (status == PluginResult.Status.OK.ordinal() || status == PluginResult.Status.NO_RESULT.ordinal()) {
                                        PluginManager.this.app.sendJavascript(cr.toSuccessCallbackString(callbackId));
                                    } else {
                                        PluginManager.this.app.sendJavascript(cr.toErrorCallbackString(callbackId));
                                    }
                                }
                            }
                            catch (Exception e) {
                                PluginResult cr = new PluginResult(PluginResult.Status.ERROR, e.getMessage());
                                PluginManager.this.app.sendJavascript(cr.toErrorCallbackString(callbackId));
                            }
                        }
                    });
                    thread.start();
                    return "";
                }
                cr = plugin.execute(action, args, callbackId);
                if (cr.getStatus() == PluginResult.Status.NO_RESULT.ordinal() && cr.getKeepCallback()) {
                    return "";
                }
            }
        }
        catch (JSONException e) {
            System.out.println("ERROR: " + e.toString());
            cr = new PluginResult(PluginResult.Status.JSON_EXCEPTION);
        }
        if (runAsync) {
            if (cr == null) {
                cr = new PluginResult(PluginResult.Status.CLASS_NOT_FOUND_EXCEPTION);
            }
            this.app.sendJavascript(cr.toErrorCallbackString(callbackId));
        }
        return cr != null ? cr.getJSONString() : "{ status: 0, message: 'all good' }";
    }

    private IPlugin getPlugin(String service) {
        PluginEntry entry = this.entries.get(service);
        if (entry == null) {
            return null;
        }
        IPlugin plugin = entry.plugin;
        if (plugin == null) {
            plugin = entry.createPlugin(this.app, this.ctx);
        }
        return plugin;
    }

    public void addService(String service, String className) {
        PluginEntry entry = new PluginEntry(service, className, false);
        this.addService(entry);
    }

    public void addService(PluginEntry entry) {
        this.entries.put(entry.service, entry);
    }

    public void onPause(boolean multitasking) {
        for (PluginEntry entry : this.entries.values()) {
            if (entry.plugin == null) continue;
            entry.plugin.onPause(multitasking);
        }
    }

    public void onResume(boolean multitasking) {
        for (PluginEntry entry : this.entries.values()) {
            if (entry.plugin == null) continue;
            entry.plugin.onResume(multitasking);
        }
    }

    public void onDestroy() {
        for (PluginEntry entry : this.entries.values()) {
            if (entry.plugin == null) continue;
            entry.plugin.onDestroy();
        }
    }

    public Object postMessage(String id, Object data) {
        Object obj = this.ctx.onMessage(id, data);
        if (obj != null) {
            return obj;
        }
        for (PluginEntry entry : this.entries.values()) {
            if (entry.plugin == null || (obj = entry.plugin.onMessage(id, data)) == null) continue;
            return obj;
        }
        return null;
    }

    public void onNewIntent(Intent intent) {
        for (PluginEntry entry : this.entries.values()) {
            if (entry.plugin == null) continue;
            entry.plugin.onNewIntent(intent);
        }
    }

    public boolean onOverrideUrlLoading(String url) {
        for (Map.Entry<String, String> pairs : this.urlMap.entrySet()) {
            if (!url.startsWith(pairs.getKey())) continue;
            return this.getPlugin(pairs.getValue()).onOverrideUrlLoading(url);
        }
        return false;
    }

    private void pluginConfigurationMissing() {
        LOG.e(TAG, "=====================================================================================");
        LOG.e(TAG, "ERROR: plugin.xml is missing.  Add res/xml/plugins.xml to your project.");
        LOG.e(TAG, "https://git-wip-us.apache.org/repos/asf?p=incubator-cordova-android.git;a=blob;f=framework/res/xml/plugins.xml");
        LOG.e(TAG, "=====================================================================================");
    }
}

