package main

import (
	"database/sql"
	"flag"
	"fmt"
	"net/http"

	_ "github.com/go-sql-driver/mysql"
)

var (
	user   = flag.String("user", "", "The database user name")
	passwd = flag.String("password", "", "The database password")
	db     = flag.String("database", "", "The database to connect to")
	query  = flag.String("query", "", "The test query")
	addr   = flag.String("address", "localhost:8080",
		"The address to listen on")
)

// Podstawowe użycie:
// db-check --query="SELECT * from my-cool-table" \
// --user=bdburns \
// --passwd="you wish"
func main() {
	flag.Parse()
	db, err := sql.Open("mysql", fmt.Sprintf("%s:%s@/%s", *user, *passwd, *db))
	if err != nil {
		fmt.Printf("Błąd przy otwieraniu bazy danych: %v", err)
	}
	// Prosty obiekt obsługujący sieć, który uruchamia zapytanie
	http.HandleFunc("/", func(res http.ResponseWriter, req *http.Request) {
		_, err := db.Exec(*query)
		if err != nil {
			res.WriteHeader(http.StatusInternalServerError)
			res.Write([]byte(err.Error()))
			return
		}
		res.WriteHeader(http.StatusOK)
		res.Write([]byte("OK"))
		return
	})
	// Uruchomienie serwera
	http.ListenAndServe(*addr, nil)
}
