//! Kontroler symulacji.
//!
//! Algorytm symulacji jest złożony i oferuje wiele możliwych do użycia parametrów.

use std::fs::File;
use std::time::Duration;
use plant_structures::{Fern, FernType};

/// Symulowany świat.
pub struct Terrarium {
    ferns: Vec<Fern>
}

impl Terrarium {
    /// Tworzymy nowe, puste terrarium.
    pub fn new() -> Terrarium {
        Terrarium { ferns: vec![] }
    }

    /// Ładujemy stan terrarium z pliku typu `.tm`.
    pub fn load(filename: &str) -> Terrarium {
        // Poniższa implementacja jest oczywiście fikcją.
        File::open(filename).unwrap();  // sprawdzenie istnienia pliku
        Terrarium {
            ferns: vec![
                Fern::new(FernType::Fiddlehead)
            ]
        }
    }

    /// Pobranie referencji symulowanej paproci.
    pub fn fern(&self, index: usize) -> &Fern {
        &self.ferns[index]
    }

    #[allow(unused_variables)]
    /// Symulacja oświetlenia słonecznego przez określony czas
    ///
    ///     # use fern_sim::Terrarium;
    ///     # use std::time::Duration;
    ///     # let mut tm = Terrarium::new();
    ///     tm.apply_sunlight(Duration::from_secs(60));
    ///
    pub fn apply_sunlight(&mut self, time: Duration) {
        for f in &mut self.ferns {
            for s in &mut f.stems {
                s.furled = false;
            }
        }
    }
}
