//! Ogólna kontrola symulacji
//!
//! Algorytm symulacji jest złożony i ma wiele modyfikowalnych parametrów

use std::fs::File;
use std::time::Duration;
use crate::plant_structures::{Fern, FernType};

/// The simulated universe.
pub struct Terrarium {
    ferns: Vec<Fern>
}

impl Terrarium {
    /// Tworzym nowe puste terrarium
    pub fn new() -> Terrarium {
        Terrarium { ferns: vec![] }
    }

    /// Wczytuje terrarium z pliku `.tm`
    pub fn load(filename: &str) -> Terrarium {
        // Implementacja jest zupełnie fikcyjna.
        File::open(filename).unwrap();  // Sprawdzamy, czy plik istnieje
        Terrarium {
            ferns: vec![
                Fern::new(FernType::Fiddlehead)
            ]
        }
    }

    /// Pobiera referencję do paproci w symulatorze
    pub fn fern(&self, index: usize) -> &Fern {
        &self.ferns[index]
    }

    #[allow(unused_variables)]
    /// Włączamy słońce i przeprowadzamy symulację przez określony czas
    ///
    ///     # use fern_sim::Terrarium;
    ///     # use std::time::Duration;
    ///     # let mut tm = Terrarium::new();
    ///     tm.apply_sunlight(Duration::from_secs(60));
    ///
    pub fn apply_sunlight(&mut self, time: Duration) {
        for f in &mut self.ferns {
            for s in &mut f.stems {
                s.furled = false;
            }
        }
    }
}
